/*
 *  FSDirectoryMonitor.h
 *  Created by Martin Hwasser on 12/19/11.
 *  Modified by LI DONG on 02/07/13
 */

#import <Foundation/Foundation.h>

@protocol FSDirectoryMonitorDelegate <NSObject>
@required
- (void)directoryDidChangeItems:(NSSet *)items;
- (void)directoryDidFinishChanging;
@end

@interface FSDirectoryMonitor : NSObject {
    dispatch_source_t _source;
    NSInteger _pollingTimesLeft;
    NSString *_monitoringPath;
    NSMutableSet *_metadata;
    __weak id<FSDirectoryMonitorDelegate> _delegate;
    dispatch_queue_t _monitoringQueue;
    BOOL _directoryChanged;
}

- (id)initWithPath:(NSString *)path;

// Returns YES if started watching, NO if already is watching
- (BOOL)startMonitoringWithDelegate:(id<FSDirectoryMonitorDelegate>)delegate;

- (void)stopMonitoring;

// The path being watched
@property (nonatomic, readonly, copy) NSString *monitoringPath;

@end
